/*
 * fc_usb_tcu_US_JSONParser.cpp
 *
 *  Created on: Mar 19, 2015
 *      Author: kl81hc
 */

#include "fc_usb_tcu_US_JSONParser.h"

#include "fc_usb_tcu_trace_classes.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_USB_TCU_EVENTMANG_SOCKET
#include "trcGenProj/Header/fc_usb_tcu_US_JSONParser.cpp.trc.h"
#endif


fc_usb_tcu_US_JSONParser::fc_usb_tcu_US_JSONParser(fc_usb_tcu_tclAppMain* poMainAppl):I_fc_usb_tcu_JSONParser(poMainAppl)
{

}

fc_usb_tcu_US_JSONParser::~fc_usb_tcu_US_JSONParser()
{

}

tVoid fc_usb_tcu_US_JSONParser::parseChannelMasterDataHeader(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData, tBool & bIsParsingSuccess)
{
    Json::Value jCMDHeader;
    tBool boolGetCMDHeaderJSONObj = jsonUtils.getJSONObject(jCMD, json_utils::CHANNEL_CMD_HEADER, jCMDHeader);
    if (boolGetCMDHeaderJSONObj)
    {
		//Get the number of Folder definition info.
		tU8 u8NumOfFolderDefInfo;
		tBool boolGetNumOfFolderDefInfo = jsonUtils.gettU8UInt(jCMDHeader, json_utils::U8_NUM_OF_FOLDER_DEF_INFO, u8NumOfFolderDefInfo);
		if (boolGetNumOfFolderDefInfo)
		{
			oChannelMasterData.ChannelMasterData.ChannelMasterDataHeader.u8NumOfFolderDefInfo = u8NumOfFolderDefInfo;
		}
		else
		{
			ETG_TRACE_USR2(("Parsing NumOfFolderDefInfo FAILED!!"));
			bIsParsingSuccess = false;
		}

		//Get the number of Channel definition info.
		tU16 u16NumOfChannelDefInfo;
		tBool boolNumOfChannelDefInfo = jsonUtils.gettU16UInt(jCMDHeader, json_utils::U16_NUM_OF_CHANNEL_DEF_INFO, u16NumOfChannelDefInfo);
		if (boolNumOfChannelDefInfo)
		{
			oChannelMasterData.ChannelMasterData.ChannelMasterDataHeader.u16NumOfChannelDefInfo = u16NumOfChannelDefInfo;
		}
		else
		{
			ETG_TRACE_USR2(("Parsing NumOfChannelDefInfo FAILED!!"));
			bIsParsingSuccess = false;
		}

	}
    else
	{
		ETG_TRACE_USR2(("Parsing CMDHeader FAILED!!"));
		bIsParsingSuccess = false;
	}
}

tVoid fc_usb_tcu_US_JSONParser::parseFolderDefinitionInformation(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData, tBool & bIsParsingSuccess)
{
    Json::Value jFolderDefinitionInformation;
    tBool boolFolderDefinitionInformation = jsonUtils.getJSONArray(jCMD, json_utils::FOLDER_DEFINITION_INFORMATION, jFolderDefinitionInformation);
    if (boolFolderDefinitionInformation)
    {
		//Resize
		oChannelMasterData.ChannelMasterData.FolderDefinitionInformation.resize(jFolderDefinitionInformation.size());

		//Update the Folder definition Information for each Folder
		for (unsigned int i = 0; i < jFolderDefinitionInformation.size(); i++)
		{

			// Get FolderID
			tU16 u16FolderID;
			tBool boolu16FolderID = jsonUtils.gettU16UInt(jFolderDefinitionInformation[i],json_utils::U16_FOLDER_ID, u16FolderID);
			ETG_TRACE_USR2(("<< Parsing u16FolderID  object"));
			if (boolu16FolderID)
			{
				oChannelMasterData.ChannelMasterData.FolderDefinitionInformation[i].u16FolderID = u16FolderID;
			}
			else
			{
				ETG_TRACE_USR2(("Parsing FolderID FAILED!!"));
				bIsParsingSuccess = false;
			}

			// Get FolderName
			bpstl::string strFolderName;
			tBool boolFolderName = jsonUtils.getString(jFolderDefinitionInformation[i], json_utils::STR_FOLDER_NAME, strFolderName);
			ETG_TRACE_USR2(("<< Parsing strFolderName  object"));
			if (boolFolderName)
			{
				oChannelMasterData.ChannelMasterData.FolderDefinitionInformation[i].strFolderName = strFolderName;
			}
			else
			{
				ETG_TRACE_USR2(("Parsing FolderName FAILED!!"));
				bIsParsingSuccess = false;
			}

			tU16 u16FolderIconID;
			tBool boolFolderIconID = jsonUtils.gettU16UInt(jFolderDefinitionInformation[i], json_utils::U16_FOLDER_ICON_ID, u16FolderIconID);
			ETG_TRACE_USR2(("<< Parsing u16FolderIconID  object"));
			if (boolFolderIconID)
			{
				oChannelMasterData.ChannelMasterData.FolderDefinitionInformation[i].u16FolderIconID = u16FolderIconID;
			}
			else
			{
				ETG_TRACE_USR2(("Parsing FolderIconID FAILED!!"));
				bIsParsingSuccess = false;
			}

		}
	}
    else
    {
		ETG_TRACE_USR2(("Parsing FolderDefinitionInformation FAILED!!"));
		bIsParsingSuccess = false;
	}
}


tVoid fc_usb_tcu_US_JSONParser::parseChannelDefinitionInformation(Json::Value & jCMD, T_tcu_channel_master_data_result & oChannelMasterData, tBool & bIsParsingSuccess)
{
    Json::Value jChannelDefinitionInformation;
    tBool boolChannelDefinitionInformation = jsonUtils.getJSONArray(jCMD, json_utils::CHANNEL_DEFINITION_INFORMATION, jChannelDefinitionInformation);
    ETG_TRACE_USR2(("<< Parsing ChannelDefinitionInformation  object"));
    if (boolChannelDefinitionInformation) {
		//Resize
		oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation.resize(jChannelDefinitionInformation.size());

		//Update the Channel definition Information for each Folder
		for (unsigned int i = 0; i < jChannelDefinitionInformation.size(); i++)
		{

			// Get ChannelID
			tU16 u16ChannelID;
			tBool boolChannelID = jsonUtils.gettU16UInt(jChannelDefinitionInformation[i],json_utils::U16_CHANNEL_ID, u16ChannelID);

			if (boolChannelID)
			{
				oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u16ChannelID = u16ChannelID;
			}
			else
			{
				ETG_TRACE_USR2(("Parsing ChannelID FAILED!!"));
				bIsParsingSuccess = false;
			}

			// Get ChannelName
			bpstl::string strChannelName;
			tBool boolChannelName = jsonUtils.getString(jChannelDefinitionInformation[i], json_utils::STR_CHANNEL_NAME, strChannelName);

			if (boolChannelName)
			{
				oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].strChannelName = strChannelName;
			} else
			{
				ETG_TRACE_USR2(("Parsing ChannelName FAILED!!"));
				bIsParsingSuccess = false;
			}

			// Get FolderID
			tU16 u16FolderID;
			tBool boolu16FolderID = jsonUtils.gettU16UInt(jChannelDefinitionInformation[i], json_utils::U16_FOLDER_ID, u16FolderID);

			if (boolu16FolderID) {
				oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u16FolderID = u16FolderID;
			}
			else
			{
				ETG_TRACE_USR2(("Parsing ChannelDefinitionInformation-FolderID FAILED!!"));
				bIsParsingSuccess = false;
			}

			tU16 u16ChannelIconID;
			tBool boolChannelIconID = jsonUtils.gettU16UInt(jChannelDefinitionInformation[i], json_utils::U16_CHANNEL_ICON_ID, u16ChannelIconID);
			if (boolChannelIconID)
			{
				oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u16ChannelIconID = u16ChannelIconID;
			}
			else
			{
				ETG_TRACE_USR2(("Parsing ChannelIconID FAILED!!"));
				bIsParsingSuccess = false;
			}

			tU8 u8FlagOfChannelInfo;
			tBool boolFlagOfChannelInfo = jsonUtils.gettU8UInt(jChannelDefinitionInformation[i], json_utils::U8_FLAG_OF_CHANNEL_INFO,
					u8FlagOfChannelInfo);
			if (boolFlagOfChannelInfo)
			{
				oChannelMasterData.ChannelMasterData.ChannelDefinitionInformation[i].u8FlagOfChannelInfo = u8FlagOfChannelInfo;
			}
			else
			{
				ETG_TRACE_USR2(("Parsing FlagOfChannelInfo FAILED!!"));
				bIsParsingSuccess = false;
			}
		}
	}
    else
    {
		ETG_TRACE_USR2(("Parsing ChannelDefinitionInformation FAILED!!"));
		bIsParsingSuccess = false;
	}
}


tBool fc_usb_tcu_US_JSONParser::vParseChannelMasterDataJSON(Json::Value& root, T_tcu_channel_master_data_result& oChannelMasterData)
{
	ETG_TRACE_USR2(("<< parseChannelMasterDataJSON"));

	tBool bIsParsingSuccess = true;

	//Get ChannelMasterData JSON message
	Json::Value jCMD;
	tBool boolGetCMDJSONObj = jsonUtils.getJSONObject(root, json_utils::CHANNEL_MASTER_DATA, jCMD);

	if (boolGetCMDJSONObj)
	{
		parseChannelMasterDataHeader(jCMD, oChannelMasterData, bIsParsingSuccess);
		if(bIsParsingSuccess){
			parseFolderDefinitionInformation(jCMD, oChannelMasterData, bIsParsingSuccess);
		}
		if(bIsParsingSuccess){
			parseChannelDefinitionInformation(jCMD, oChannelMasterData, bIsParsingSuccess);
		}
	} else {
		bIsParsingSuccess = false;
	}

	if (!bIsParsingSuccess)
	{
		ETG_TRACE_USR2(("Parsing JSON FAILED!!"));
	}

	return bIsParsingSuccess;
}

tBool fc_usb_tcu_US_JSONParser::parseChannelDataInformationHeaderPart(Json::Value& jChannelData, T_tcu_channel_data_information_header& oDest)
{
	ETG_TRACE_USR2(("-> parseChannelDataInformationHeaderPart()"));
	tBool bIsParsingSuccess = FALSE;

	Json::Value jChannelDataInformationHeaderPart;
	bIsParsingSuccess = jsonUtils.getJSONObject(jChannelData, json_utils::CHANNEL_DATA_INFO_HEADER_PART, jChannelDataInformationHeaderPart);
	/*####### ChannelDataInformationHeaderPart BEGIN ########*/

	//Get the channel info type
	tU8 u8ChannelInfoType = 0;
	T_e8_tcu_Channel_Info_Type e8ChannelInfoType;
	ETG_TRACE_USR1(("jChannelData JSON =\n %s", jChannelDataInformationHeaderPart.toStyledString().c_str()));
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationHeaderPart, json_utils::U8_CHANNEL_INFO_TYPE, u8ChannelInfoType);
	}

	tU16 u16ChannelID = 0;
	if(bIsParsingSuccess == TRUE)
	{
		// Set info_type as enum.
		e8ChannelInfoType = T_e8_tcu_Channel_Info_Type::tenType(u8ChannelInfoType);

		//Get the channel ID
		bIsParsingSuccess = jsonUtils.gettU16UInt(jChannelDataInformationHeaderPart, json_utils::U16_CHANNEL_ID, u16ChannelID);
	}

	//Get the channel name
	bpstl::string strChannelName;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationHeaderPart, json_utils::STR_CHANNEL_NAME, strChannelName);
	}

	//Get the number of channel contents
	tU8 u8NumOfChannelContents = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationHeaderPart, json_utils::U8_NUM_OF_CHANNEL_CONTENTS, u8NumOfChannelContents);
	}

	//Get the number of execution info
	tU8 u8NumOfExecInfo = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationHeaderPart, json_utils::U8_NUM_OF_EXEC_INFO, u8NumOfExecInfo);
	}

	//Get the number of channel contents at one time
	tU8 u8NumOfChannelContentsAtOneTime = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationHeaderPart, json_utils::U8_NUM_OF_CHANNEL_CONTENTS_AT_ONE_TIME, u8NumOfChannelContentsAtOneTime);
	}

	//Get the total number of channel contents
	tU8 u8TotalNumOfChannelContents = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationHeaderPart, json_utils::U8_TOTAL_NUM_OF_CHANNEL_CONTENTS, u8TotalNumOfChannelContents);
	}

	if(bIsParsingSuccess == TRUE)
	{
		T_tcu_channel_data_information_header oChannelDataInformationHeaderPart(
				e8ChannelInfoType,
				u16ChannelID,
				strChannelName,
				u8NumOfChannelContents,
				u8NumOfExecInfo,
				u8NumOfChannelContentsAtOneTime,
				u8TotalNumOfChannelContents
				);
		oDest = oChannelDataInformationHeaderPart;
	}

	/*####### ChannelDataInformationHeaderPart END ########*/
	ETG_TRACE_USR2(("<- parseChannelDataInformationHeaderPart()"));

	return bIsParsingSuccess;
}


tBool fc_usb_tcu_US_JSONParser::parseChannelDataInformationRecordPart(Json::Value& jChannelData, T_tcu_channel_data_information& oDest)
{
	ETG_TRACE_USR2(("-> parseChannelDataInformationRecordPart()"));
	tBool bIsParsingSuccess = FALSE;

	//Get ChannelDataInformationRecordPart JSON message
	Json::Value jChannelDataInformationRecordPart;
	bIsParsingSuccess = jsonUtils.getJSONArray(jChannelData, json_utils::CHANNEL_DATA_INFORMATION_RECORD_PART, jChannelDataInformationRecordPart);

	if(bIsParsingSuccess == TRUE)
	{
		//Resize
		oDest.ChannelDataInformationRecordPart.resize(jChannelDataInformationRecordPart.size());

		/*####### ChannelDataInformationRecordPart BEGIN ########*/
		for (tC16 i=0; i < jChannelDataInformationRecordPart.size(); i++)
		{
			bIsParsingSuccess = parseChannelDataInformationRecordItem(jChannelDataInformationRecordPart[i],oDest.ChannelDataInformationRecordPart[i]);
			if(!bIsParsingSuccess)
			{
				break;
			}
		}
		/*####### ChannelDataInformationRecordPart END ########*/
	}

	ETG_TRACE_USR2(("<- parseChannelDataInformationRecordPart()"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_US_JSONParser::parseChannelDataInformationRecordItem(Json::Value & jChannelDataInformationRecordPart, T_tcu_channel_data_information_record & oDest)
{
	tBool bIsParsingSuccess = FALSE;

	//Get the channel content ID
	tU8 u8ChannelContentsID = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_CHANNEL_CONTENTS_ID, u8ChannelContentsID);

	//Get the title
	bpstl::string strTitle;
	if (bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_TITLE, strTitle);
	}

	//Get the title for TTS
	bpstl::string strTitleForTTS;
	if (bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_TITLE_FOR_TTS, strTitleForTTS);
	}

	//Get Location JSON message
	T_tcu_Location oLocation;
	if (bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = parseLocation(jChannelDataInformationRecordPart,oLocation);
	}

	//Get the Location Attribute
	tU8 u8LocationAttribute = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_LOCATION_ATTRIBUTE, u8LocationAttribute);
	}

	T_e8_tcu_Location_Attribute e8LocationAttribute;
	tU8 u8DestOrWayPointType = 0;
	if(bIsParsingSuccess == TRUE)
	{
		// Set LocationAttribute as ENUM.
		e8LocationAttribute = T_e8_tcu_Location_Attribute::tenType(u8LocationAttribute);

		//Get the Destination Or Way Point Type
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_DEST_OR_WAYPOINT_TYPE, u8DestOrWayPointType);
	}

	T_e8_tcu_Dest_Or_WayPointType e8DestOrWayPointType;
	bpstl::string strAddress;
	if(bIsParsingSuccess == TRUE)
	{
		e8DestOrWayPointType = T_e8_tcu_Dest_Or_WayPointType::tenType(u8DestOrWayPointType);

		//Get the Address
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_ADDRESS, strAddress);
	}


	//Get the Phone Number
	bpstl::string strPhoneNumber;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_PHONE_NUMBER, strPhoneNumber);
	}

	//Get the Phone Number For Display
	bpstl::string strPhoneNumberForDisp;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_PHONE_NUMBER_FOR_DISP, strPhoneNumberForDisp);
	}

	//Get the Text
	bpstl::string strText;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_TEXT, strText);
	}

	//Get the Text For TTS
	bpstl::string strTextForTTS;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_TEXT_FOR_TTS, strTextForTTS);
	}

	//Get the Icon ID
	tU16 u16IconID = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU16UInt(jChannelDataInformationRecordPart, json_utils::U16_ICON_ID, u16IconID);
	}

	//Get the Sound ID For Beginning Of Play
	tU16 u16SoundIDForBeginningOfPlay = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU16UInt(jChannelDataInformationRecordPart, json_utils::U16_SOUNDID_FOR_BEGINNING_OF_PLAY, u16SoundIDForBeginningOfPlay);
	}

	//Get the Sound ID For BGM
	tU16 u16SoundIDForBGM = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU16UInt(jChannelDataInformationRecordPart, json_utils::U16_SOUNDID_FOR_BGM, u16SoundIDForBGM);
	}

	//Get the Action SW ID
	tU8 u8ActionSWID = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_ACTION_SWID, u8ActionSWID);
	}

	//Get the Parameter Of Action SW
	tU32 u32ParameterOfActionSW = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU32UInt(jChannelDataInformationRecordPart, json_utils::U32_PARAMETEROF_ACTION_SW, u32ParameterOfActionSW);
	}

	//Get the Flag Of Display Button Ctrl
	tU8 u8FlagOfDispButtonCtrl = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_FLAG_OF_DISP_BUTTON_CTRL, u8FlagOfDispButtonCtrl);
	}

	//Get the Flag Of Ctrl During Running
	tU8 u8FlagOfCtrlDuringRunning = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_FLAG_OF_CTRL_DURING_RUNNING, u8FlagOfCtrlDuringRunning);
	}

	//Get the Name Of Image Button
	bpstl::string strNameOfImageButton;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_NAME_OF_IMAGE_BUTTON, strNameOfImageButton);
	}

	//Get the Name Of Action SW
	bpstl::string strNameOfActionSW = jChannelDataInformationRecordPart.get("strNameOfActionSW", "ERROR").asCString();
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_NAME_OF_ACTION_SW, strNameOfActionSW);
	}

	//Get the Flag Of Execution Of Channel Contents
	tU8 u8FlagOfExecOfChannelContents = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_FLAG_OF_EXEC_OF_CHANNEL_CONTENTS, u8FlagOfExecOfChannelContents);
	}

	//Get the Flag Of Storing Ctrl
	tU8 u8FlagOfStoringCtrl = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_FLAG_OF_STORING_CTRL, u8FlagOfStoringCtrl);
	}

	//Get the Image Availability
	tU8 u8ImageAvailability = 0;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jChannelDataInformationRecordPart, json_utils::U8_IMAGE_AVAILABILITY, u8ImageAvailability);
	}

	//Get the Image Location
	bpstl::string strImageLocation;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getString(jChannelDataInformationRecordPart, json_utils::STR_IMAGE_LOCATION, strImageLocation);
	}

	if(bIsParsingSuccess == TRUE)
	{
		T_tcu_channel_data_information_record oChannelDataInformationRecordPart(u8ChannelContentsID,
				strTitle,
				strTitleForTTS,
				oLocation,
				e8LocationAttribute,
				e8DestOrWayPointType,
				strAddress,
				strPhoneNumber,
				strPhoneNumberForDisp,
				strText,
				strTextForTTS,
				u16IconID,
				u16SoundIDForBeginningOfPlay,
				u16SoundIDForBGM,
				u8ActionSWID,
				u32ParameterOfActionSW,
				u8FlagOfDispButtonCtrl,
				u8FlagOfCtrlDuringRunning,
				strNameOfImageButton,
				strNameOfActionSW,
				u8FlagOfExecOfChannelContents,
				u8FlagOfStoringCtrl,
				u8ImageAvailability,
				strImageLocation
				);
		oDest = oChannelDataInformationRecordPart;
	}

	return bIsParsingSuccess;
}

tBool fc_usb_tcu_US_JSONParser::parseLocation(Json::Value & jChannelDataInformationRecordPart, T_tcu_Location& oLocation)
{
	ETG_TRACE_USR2(("<< parseChannelDataJSON"));

	Json::Value jLocation;
	tBool bIsParsingSuccess = jsonUtils.getJSONObject(jChannelDataInformationRecordPart, json_utils::LOCATION, jLocation);

	if(bIsParsingSuccess == TRUE)
	{
		//Get the channel content ID
		tU8 u8Direction = 0;
		bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_DIRECTION, u8Direction);

		//Get the Longitude Degree
		tU8 u8Longitude_degree = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LONGITUDE_DEGREE, u8Longitude_degree);
		}

		//Get the Longitude minute
		tU8 u8Longitude_minute = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LONGITUDE_MINUTE, u8Longitude_minute);
		}

		//Get the Longitude second
		tU16 u16Longitude_second = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU16UInt(jLocation, json_utils::U16_LONGITUDE_SECOND, u16Longitude_second);
		}
		//Get the Latitude degree
		tU8 u8Latitude_degree = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LATITUDE_DEGREE, u8Latitude_degree);
		}

		//Get the Latitude minute
		tU8 u8Latitude_minute = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU8UInt(jLocation, json_utils::U8_LATITUDE_MINUTE, u8Latitude_minute);
		}

		//Get the Latitude second
		tU16 u16Latitude_second = 0;
		if(bIsParsingSuccess == TRUE)
		{
			bIsParsingSuccess = jsonUtils.gettU16UInt(jLocation, json_utils::U16_LATITUDE_SECOND, u16Latitude_second);
		}

		if(bIsParsingSuccess == TRUE)
		{
			T_tcu_Location tempoLocation(u8Direction, u8Longitude_degree, u8Longitude_minute, u16Longitude_second, u8Latitude_degree, u8Latitude_minute, u16Latitude_second);
			oLocation = tempoLocation;
		}
	}

	ETG_TRACE_USR2(("<< parseLocation"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_US_JSONParser::vParseChannelDataJSON(Json::Value& root, T_tcu_channel_data_result& oChannelData)
{
	ETG_TRACE_USR2(("<< parseChannelDataJSON"));
	tBool bIsParsingSuccess = FALSE;

	//Get ChannelData JSON message
	Json::Value jChannelData;
	bIsParsingSuccess = jsonUtils.getJSONArray(root, json_utils::CHANNEL_DATA, jChannelData);

	if (bIsParsingSuccess == TRUE)
	{
		//Resize
		oChannelData.ChannelData.resize(jChannelData.size());
		for (tC16 i=0; i < jChannelData.size(); i++)
		{
		  //Get ChannelDataInformationHeaderPart JSON message
		  bIsParsingSuccess  = parseChannelDataInformationHeaderPart(jChannelData[i], oChannelData.ChannelData[i].ChannelDataInformationHeaderPart);

		  //Get parseChannelDataInformationRecordPart JSON message
		  if(bIsParsingSuccess == TRUE)
		  {
			  bIsParsingSuccess = parseChannelDataInformationRecordPart(jChannelData[i], oChannelData.ChannelData[i]);
		  }

		  //Get ExecutionInformation
		  if(bIsParsingSuccess) {

			  /*
			   * US CarWings protocol has single ExecutionInformation. Other regions CW protocol have an array of ExecutionInformation.
			   * Thus, ExecutionInformation is resized to 1 and hard-coded index 0 is used.
			   */
			  oChannelData.ChannelData[i].ExecutionInformation.resize(1);
			  bIsParsingSuccess = parseExecutionInformation(jChannelData[i],oChannelData.ChannelData[i].ExecutionInformation[0]);
			  
		  }

		  if(bIsParsingSuccess == FALSE)
		  {
			ETG_TRACE_USR2(("parse failed for %d Channel",i));
			break;
		  }
		}
	}
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_US_JSONParser::parseExecutionInformation(Json::Value & jChannelDataInformationRecordPart,T_tcu_Exection_Information& oExecutionInformation)
{
	ETG_TRACE_USR2(("<< parseExecutionInformation"));
	tBool bIsParsingSuccess = FALSE;

	//Get ExecutionInformation JSON message
	Json::Value jExecutionInformation;
	bIsParsingSuccess = jsonUtils.getJSONObject(jChannelDataInformationRecordPart, json_utils::EXECUTION_INFORMATION, jExecutionInformation);

	/*####### ExecutionInformation BEGIN ########*/

	//Get the Execution type
	tU8 u8ExecType = 0;
	T_e8_tcu_ExecType e8ExecType;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.gettU8UInt(jExecutionInformation, json_utils::U8_EXEC_TYPE, u8ExecType);
	}

	Json::Value jExectionDetails;
	if(bIsParsingSuccess == TRUE)
	{
		// Set u8ExecType as ENUM.
		e8ExecType = T_e8_tcu_ExecType::tenType(u8ExecType);

		//Get ExectionDetails JSON message
		bIsParsingSuccess = jsonUtils.getJSONObject(jExecutionInformation, json_utils::EXECTION_DETAILS, jExectionDetails);
	}

	//Get RouteCalc JSON message
	Json::Value jRouteCalc;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getJSONObject(jExectionDetails, json_utils::ROUTE_CALC, jRouteCalc);
	}

	/*####### RouteCalc BEGIN ########*/
	T_tcu_Route_Calc oRouteCalc;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = parseRouteCalc(jRouteCalc,oRouteCalc);
	}
	/*####### RouteCalc END ########*/

	//Get DispList JSON message
	Json::Value jDispList;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getJSONObject(jExectionDetails, json_utils::DISPLIST, jDispList);
	}

	/*####### DispList BEGIN ########*/
	T_tcu_Disp_List oDispList;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = parseDispList(jDispList,oDispList);
	}
	/*####### DispList END ########*/

	//Get AutoPlay JSON message
	Json::Value jAutoPlay;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = jsonUtils.getJSONObject(jExectionDetails, json_utils::AUTO_PLAY, jAutoPlay);

	}

	/*####### AutoPlay BEGIN ########*/
	T_tcu_Auto_Play oAutoPlay;
	if(bIsParsingSuccess == TRUE)
	{
		bIsParsingSuccess = parseAutoPlay(jAutoPlay,oAutoPlay);
	}

	if(bIsParsingSuccess == TRUE)
	{
		T_tcu_Detail_Of_Execution oExectionDetails(oRouteCalc, oDispList, oAutoPlay);
		T_tcu_Exection_Information tempExecutionInformation(e8ExecType, oExectionDetails);
		oExecutionInformation = tempExecutionInformation;
	}

	/*####### AutoPlay END ########*/
	/*####### ExecutionInformation END ########*/

	ETG_TRACE_USR3(("<< parseExecutionInformation"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_US_JSONParser::parseAutoPlay(Json::Value jAutoPlay, T_tcu_Auto_Play& oAutoPlay)
{
	ETG_TRACE_USR2(("<< parseAutoPlay"));
	tBool bIsParsingSuccess = FALSE;

	//Get the Number Of Channel Contents
	tU8 u8Num_Of_Channel_Contents = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jAutoPlay, json_utils::AUTO_PLAY_U8_NUM_OF_CHANNEL_CONTENTS, u8Num_Of_Channel_Contents);

	Json::Value jChannelContentsID;
	if(bIsParsingSuccess == TRUE)
	{
		oAutoPlay.u8Num_Of_Channel_Contents = u8Num_Of_Channel_Contents;

		//Get the Channel Contents ID
		bIsParsingSuccess = jsonUtils.getJSONArray(jAutoPlay, json_utils::CHANNEL_CONTENTS_ID, jChannelContentsID);
	}


	if(bIsParsingSuccess == TRUE)
	{
		//Resize
		oAutoPlay.u8ChannelContentsID.resize(jChannelContentsID.size());
		for (tC16 l=0; l < jChannelContentsID.size(); ++l)
		{
			tU8 ContentsID = jChannelContentsID[l].asUInt();
			oAutoPlay.u8ChannelContentsID[l] = ContentsID;
		}
	}

	ETG_TRACE_USR3(("<< parseAutoPlay"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_US_JSONParser::parseDispList(Json::Value jDispList, T_tcu_Disp_List& oDispList)
{

	ETG_TRACE_USR2(("<< parseDispList"));
	tBool bIsParsingSuccess = FALSE;

	//Get the Number Of Channel Contents
	tU8 NumOfChannelContents = 0;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jDispList, json_utils::NUM_OF_CHANNEL_CONTENTS, NumOfChannelContents);

	Json::Value jChannelContentsIDDispList;
	if(bIsParsingSuccess == TRUE)
	{
		oDispList.u8NumOfChannelContents = NumOfChannelContents;

		//Get the Channel Contents ID
		bIsParsingSuccess = jsonUtils.getJSONArray(jDispList, json_utils::CHANNEL_CONTENTS_ID, jChannelContentsIDDispList);
	}

	if(bIsParsingSuccess == TRUE)
	{
		//Resize
		oDispList.u8ChannelContentsID.resize(jChannelContentsIDDispList.size());

		for (tC16 k=0; k < jChannelContentsIDDispList.size(); ++k)
		{
			tU8 ContentsID = jChannelContentsIDDispList[k].asUInt();
			oDispList.u8ChannelContentsID[k] = ContentsID;
		}
	}

	ETG_TRACE_USR3(("<< parseDispList"));
	return bIsParsingSuccess;
}

tBool fc_usb_tcu_US_JSONParser::parseRouteCalc(Json::Value jRouteCalc, T_tcu_Route_Calc& oRouteCalc)
{
	ETG_TRACE_USR2(("<< parseRouteCalc"));
	tBool bIsParsingSuccess = FALSE;

	//Get the Section Type
	tU8 u8SectionType = 0;
	T_e8_tcu_section_type eSectionType;
	bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::SECTION_TYPE, u8SectionType);


	tU8 Condition_Of_RouteCalc_all_section_or_section_1 = 0;
	T_e8_tcu_Condition_Of_Route_Calc eCondition_Of_RouteCalc_all_section_or_section_1;
	if(bIsParsingSuccess)
	{
		// Set u8SectionType as ENUM.
		eSectionType = T_e8_tcu_section_type::tenType(u8SectionType);

		//Get the Condition_Of_RouteCalc_all_section_or_section_1
		bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::CONDITION_OF_ROUTECALC_ALL_SECTION_OR_SECTION_1, Condition_Of_RouteCalc_all_section_or_section_1);
	}

	tU8 Condition_Of_Route_Calc_section_2 = 0;
	T_e8_tcu_Condition_Of_Route_Calc eCondition_Of_Route_Calc_section_2;
	if(bIsParsingSuccess == TRUE)
	{
		// Set u8SectionType as ENUM.
		 eCondition_Of_RouteCalc_all_section_or_section_1 = T_e8_tcu_Condition_Of_Route_Calc::tenType(Condition_Of_RouteCalc_all_section_or_section_1);

		//Get the Condition_Of_Route_Calc_section_2
		bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::CONDITION_OF_ROUTE_CALC_SECTION_2, Condition_Of_Route_Calc_section_2);
	}

	tU8 Condition_Of_Route_Calc_section_3 = 0;
	T_e8_tcu_Condition_Of_Route_Calc eCondition_Of_Route_Calc_section_3;
	if(bIsParsingSuccess == TRUE)
	{
		// Set u8SectionType as ENUM.
		eCondition_Of_Route_Calc_section_2 = T_e8_tcu_Condition_Of_Route_Calc::tenType(Condition_Of_Route_Calc_section_2);

		//Get the Condition_Of_Route_Calc_section_3
		bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::CONDITION_OF_ROUTE_CALC_SECTION_3, Condition_Of_Route_Calc_section_3);
	}

	tU8 Condition_Of_Route_Calc_section_4 = 0;
	T_e8_tcu_Condition_Of_Route_Calc eCondition_Of_Route_Calc_section_4;
	if(bIsParsingSuccess == TRUE)
	{
		// Set u8SectionType as ENUM.
		eCondition_Of_Route_Calc_section_3 = T_e8_tcu_Condition_Of_Route_Calc::tenType(Condition_Of_Route_Calc_section_3);

		//Get the Condition_Of_Route_Calc_section_4
		bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::CONDITION_OF_ROUTE_CALC_SECTION_4, Condition_Of_Route_Calc_section_4);
	}

	tU8 Condition_Of_Route_Calc_section_5 = 0;
	T_e8_tcu_Condition_Of_Route_Calc eCondition_Of_Route_Calc_section_5;
	if(bIsParsingSuccess == TRUE)
	{
		// Set u8SectionType as ENUM.
		eCondition_Of_Route_Calc_section_4 = T_e8_tcu_Condition_Of_Route_Calc::tenType(Condition_Of_Route_Calc_section_4);

		//Get the Condition_Of_Route_Calc_section_5
		bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::CONDITION_OF_ROUTE_CALC_SECTION_5, Condition_Of_Route_Calc_section_5);
	}

	tU8 Condition_Of_Route_Calc_section_6 = 0;
	T_e8_tcu_Condition_Of_Route_Calc eCondition_Of_Route_Calc_section_6;
	if(bIsParsingSuccess == TRUE)
	{
		// Set u8SectionType as ENUM.
		eCondition_Of_Route_Calc_section_5 = T_e8_tcu_Condition_Of_Route_Calc::tenType(Condition_Of_Route_Calc_section_5);

		//Get the Condition_Of_Route_Calc_section_6
		bIsParsingSuccess = jsonUtils.gettU8UInt(jRouteCalc, json_utils::CONDITION_OF_ROUTE_CALC_SECTION_6, Condition_Of_Route_Calc_section_6);
	}

	if(bIsParsingSuccess == TRUE)
	{
		// Set u8SectionType as ENUM.
		eCondition_Of_Route_Calc_section_6 = T_e8_tcu_Condition_Of_Route_Calc::tenType(Condition_Of_Route_Calc_section_6);

		T_tcu_Route_Calc tempRouteCalc(eSectionType, eCondition_Of_RouteCalc_all_section_or_section_1, eCondition_Of_Route_Calc_section_2, eCondition_Of_Route_Calc_section_3, eCondition_Of_Route_Calc_section_4, eCondition_Of_Route_Calc_section_5, eCondition_Of_Route_Calc_section_6);
		oRouteCalc = tempRouteCalc;
	}

	ETG_TRACE_USR3(("<< parseRouteCalc"));
	return bIsParsingSuccess;
}
